<?php get_header(); ?>
<main>

    <div class="wrapper_main">
        <div class="container">
            <div class="wrapper_content">
                <div class="title_wrapper">
                    <div>
                        <div class="icon_title">
                            <?php include locate_template('assets/img/icon-title-12.svg'); ?>
                        </div>
                        <h2 class="title"><?php the_title() ?></h2>
                    </div>
                    <?php get_template_part('template-parts/back', 'button') ?>
                </div>
                <div class="content_box">
                    <div class="tournament_locations">
                        <div class="content_top">
                            <div class="freeroll_box">
                                <div class="freeroll_img">
                                    <img src="<?php echo wp_get_attachment_image_url(get_field('image'), 'full') ?>" alt="">
                                </div>
                                <div class="freeroll_content">
                                    <?php if ($bonus_number = get_field('bonus_number')) : ?>
                                        <div class="price"><?php echo $bonus_number ?></div>
                                    <?php endif; ?>
                                    <?php if ($bonus_text = get_field('bonus_text')) : ?>
                                        <strong><?php echo $bonus_text ?></strong>
                                    <?php endif; ?>
                                    <hr>
                                    <div class="freeroll_content_bottom">
                                        <a class="user" href="<?php echo get_author_posts_url(get_the_author_ID()) ?>">
                                            <?php include locate_template('assets/img/icon-freeroll-user.svg'); ?>
                                            <?php echo get_the_author() ?>
                                        </a>
                                        <a class="freeroll_btn" href="<?php echo tribe_get_venue_website_url(get_the_ID()) ?>">
                                            Website
                                            <?php include locate_template('assets/img/icon-freeroll-btn.svg'); ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="info">
                                <div class="info_item news">

                                    <?php if ($header_news_text = get_field('header_news_text')) : ?>
                                        <div class="title">
                                            <?php include locate_template('assets/img/icon-title-9.svg'); ?>
                                            News
                                        </div>
                                        <div class="info_txt">
                                            <?php echo $header_news_text ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php if ($prohibited_text = get_field('prohibited_activity_text')) : ?>
                                        <div class="warning">
                                            <?php include locate_template('assets/img/icon-warning.svg'); ?>
                                            <?php echo $prohibited_text ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <?php if ($when_items = get_field('when_items')) : ?>
                                    <div class="info_item when">

                                        <div class="title">
                                            <?php include locate_template('assets/img/icon-when.svg'); ?>
                                            When
                                        </div>
                                        <?php foreach ($when_items as $item) : ?>
                                            <div class="info_txt">
                                                <p><?php echo $item['text'] ?></p>
                                            </div>
                                        <?php endforeach; ?>

                                    </div>
                                <?php endif; ?>
                                <?php if ($where_text = get_field('where_text')) : ?>
                                    <div class="info_item where">
                                        <div class="title">
                                            <?php include locate_template('assets/img/icon-address.svg'); ?>
                                            Where
                                        </div>
                                        <div class="info_txt">
                                            <?php echo $where_text ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="qualifiers_box">
                            <div class="title">Qualifiers</div>
                            <div class="qualifiers_wrapper">
                                <?php
                                $venue_table_id = get_post_meta(get_the_ID(), '_PokerVenueID', true);
                                $datePlayers = poker_Connector::connector()->getVenueDatePlayers($venue_table_id);
                                // exit(var_dump($datePlayers));
                                foreach ($datePlayers as $timestamp => $users) :
                                ?>
                                    <div class="qualifiers_item">
                                        <div class="qualifiers_date">
                                            <?php include locate_template('assets/img/icon-when.svg'); ?>
                                            <?php echo date('F j', $timestamp) ?>
                                        </div>
                                        <?php foreach ($users as $wp_user_id_loop => $points_loop) : ?>
                                            <div class="qualifiers_content">
                                                <?php 
                                                global $wp_user_id, $point;
                                                $wp_user_id = $wp_user_id_loop;
                                                $points = $points_loop;
                                                get_template_part('template-parts/loop/qualifiers', 'player');
                                                ?>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>

                        </div>

                        <?php
                        get_template_part('template-parts/banner');
                        get_template_part('template-parts/member', 'card')
                        ?>
                    </div>
                </div>
                <?php get_sidebar() ?>
            </div>
        </div>
    </div>

</main>
<?php get_footer(); ?>